//---------------------------------------------------------------------------
#include <vcl.h>

#include <math.h>

#pragma hdrstop

#include "Normal1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Plot"
#pragma link "PlotMenu"
#pragma link "NEdit"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  Plot1->Align = alClient;
  StringGrid1->Cells[0][0] = "Test:";
  StringGrid1->Cells[0][1] = "Score:";
  StringGrid1->ColWidths[0] = 60;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ExitMenuItemClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::GoBitBtnClick(TObject *Sender)
{
  Single X, Y;
  Single Mean;
  Single StdDev;
  Single Min;
  Single Max;
  Single StepSize;
  Integer TheSeries;
  Single TheScore;
  Integer i;
  PSeries pMySeries;

  Plot1->SeriesList->ClearSeries();
  Plot1->Add(-1);

  Mean = MeanNEdit->AsReal;
  StdDev = StdDevNEdit->AsReal;
  Min = MinNEdit->AsReal;
  Max = MaxNEdit->AsReal;
  StepSize = StepSizeNEdit->AsReal;

//Set the axes:
  Plot1->XAxis->Max = Max;
  Plot1->XAxis->Min = Min;
  Plot1->YAxis->Min = 0;
  Plot1->XAxis->Intercept = 0;

  X = Min;
  pMySeries = (PSeries) Plot1->SeriesList->Items[0];
  do
  {
    Y = (X-Mean)/(2*StdDev);
    Y = Y * Y;
    Y = exp(-Y) / sqrt(2 * PI * StdDev);
//Don't fire any events, and don't adjust axes:
    pMySeries->AddPoint(X, Y, FALSE, FALSE);
    X = X + StepSize;
  } while (X <= Max);
  pMySeries->Visible = TRUE;

  //Plot1->YAxis->Min = Plot1->Series[0]->YMin;
  Plot1->YAxis->Max = pMySeries->YMax;

  for (i = 1; i < StringGrid1->ColCount; i++)
  {
    if (StringGrid1->Cells[i][0].Length() > 0)
    {
      if (StringGrid1->Cells[i][1].Length() > 0)
      {
        try
        {
          TheScore = StrToFloat(StringGrid1->Cells[i][1]);
          TheSeries = Plot1->Add(-1);
          pMySeries = (PSeries) Plot1->SeriesList->Items[TheSeries];
          pMySeries->Name = StringGrid1->Cells[i][0];
          pMySeries->AddPoint(TheScore, Plot1->YAxis->Min, TRUE, TRUE);
          pMySeries->AddPoint(TheScore, Plot1->YAxis->Max, TRUE, TRUE);
          pMySeries->Visible = TRUE;
          pMySeries->Symbol = (TSymbol) fmod(i, 1+sDownTriangle);
        }
        __finally 
        {}
      }
    }
  }

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PlotTypeBitBtnClick(TObject *Sender)
{
  Integer ThePlotType;

  ThePlotType = Plot1->PlotType;
  ThePlotType++;

  if (ThePlotType == ptColumn+1) ThePlotType = 0;

  Plot1->SeriesList->ClearSeries();
  Plot1->PlotType = (TPlotType) ThePlotType;
  switch (Plot1->PlotType)
  {
    case ptXY:
      Plot1->MakeDummyData(100);
      break;
    case ptMultiple:
      Plot1->MakeDummyData(20);
      break;
    case ptColumn:
      Plot1->MakeDummyData(10);
      break;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::BitBtn3Click(TObject *Sender)
{
  Plot1->MakeDummyData(100);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TraceBitBtnClick(TObject *Sender)
{
  Plot1->Trace();    
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ClearAllBitBtnClick(TObject *Sender)
{
  Integer i;

  Plot1->SeriesList->ClearSeries();
  for (i = 1; i < StringGrid1->ColCount; i++)
  {
    StringGrid1->Cells[i][0] = "";
    StringGrid1->Cells[i][1] = "";
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::GoCrazyBitBtnClick(TObject *Sender)
{
  if (CrazyTimer->Enabled)
  {
    CrazyTimer->Enabled = FALSE;
    GoCrazyBitBtn->Caption = "Go Crazy";
    TraceBitBtn->Enabled = TRUE;
  }
  else
  {
    StartWidth = Width;
    StartHeight = Height;
    Angle = 0;
    AngleInc = 4 * PI / 180;
    GoCrazyBitBtn->Caption = "Enough !";
    CrazyTimer->Enabled = TRUE;
    TraceBitBtn->Enabled = FALSE;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CrazyTimerTimer(TObject *Sender)
{
  Width = StartWidth + RADIUS * sin(Angle);
  Height = StartHeight + RADIUS * cos(Angle);
  Angle = Angle + AngleInc;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Plot1FileOpen(TObject *Sender, AnsiString TheFile)
{
  AnsiString TheTitle;

  TheTitle = ExtractFileName(Application->ExeName);
  //TheTitle = Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle.SetLength(TheTitle.Length()-4);
  TheTitle = TheTitle + " - " + ExtractFileName(TheFile);
  Application->Title = TheTitle;
  MainForm->Caption = TheTitle;
}
//---------------------------------------------------------------------------

